import numpy as np
from math import *
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import sys, random, time
from mpl_toolkits.axes_grid1.inset_locator import zoomed_inset_axes
from mpl_toolkits.axes_grid1.inset_locator import mark_inset
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

FPR_mean=np.array(np.loadtxt("centralized_learner_false_positive_mean_file.txt",dtype=float))
FPR_mean1=np.array(np.loadtxt("learner1_false_positive_mean_file.txt",dtype=float))
FPR_mean2=np.array(np.loadtxt("learner2_false_positive_mean_file.txt",dtype=float))
FPR_mean_follow=np.array(np.loadtxt("follow_false_positive_mean_file.txt",dtype=float))
FPR_mean_double=np.array(np.loadtxt("double_false_positive_mean_file.txt",dtype=float))
FPR_mean_greedy=np.array(np.loadtxt("greedy_false_positive_mean_file.txt",dtype=float))
FPR_sd=np.array(np.loadtxt("centralized_learner_false_positive_sd_file.txt",dtype=float))
FPR_sd1=np.array(np.loadtxt("learner1_false_positive_sd_file.txt",dtype=float))
FPR_sd2=np.array(np.loadtxt("learner2_false_positive_sd_file.txt",dtype=float))
FPR_sd_follow=np.array(np.loadtxt("follow_false_positive_sd_file.txt",dtype=float))
FPR_sd_double=np.array(np.loadtxt("double_false_positive_sd_file.txt",dtype=float))
FPR_sd_greedy=np.array(np.loadtxt("greedy_false_positive_sd_file.txt",dtype=float))

FNR_mean=np.array(np.loadtxt("centralized_learner_false_negative_mean_file.txt",dtype=float))
FNR_mean1=np.array(np.loadtxt("learner1_false_negative_mean_file.txt",dtype=float))
FNR_mean2=np.array(np.loadtxt("learner2_false_negative_mean_file.txt",dtype=float))
FNR_mean_follow=np.array(np.loadtxt("follow_false_negative_mean_file.txt",dtype=float))
FNR_mean_double=np.array(np.loadtxt("double_false_negative_mean_file.txt",dtype=float))
FNR_mean_greedy=np.array(np.loadtxt("greedy_false_negative_mean_file.txt",dtype=float))
FNR_sd=np.array(np.loadtxt("centralized_learner_false_negative_sd_file.txt",dtype=float))
FNR_sd1=np.array(np.loadtxt("learner1_false_negative_sd_file.txt",dtype=float))
FNR_sd2=np.array(np.loadtxt("learner2_false_negative_sd_file.txt",dtype=float))
FNR_sd_follow=np.array(np.loadtxt("follow_false_negative_sd_file.txt",dtype=float))
FNR_sd_double=np.array(np.loadtxt("double_false_negative_sd_file.txt",dtype=float))
FNR_sd_greedy=np.array(np.loadtxt("greedy_false_negative_sd_file.txt",dtype=float))

CVR_mean=np.array(np.loadtxt("centralized_learner_constraint_violation_mean_file.txt",dtype=float))
CVR_mean1=np.array(np.loadtxt("learner1_constraint_violation_mean_file.txt",dtype=float))
CVR_mean2=np.array(np.loadtxt("learner2_constraint_violation_mean_file.txt",dtype=float))
CVR_mean_follow=np.array(np.loadtxt("follow_constraint_violation_mean_file.txt",dtype=float))
CVR_mean_double=np.array(np.loadtxt("double_constraint_violation_mean_file.txt",dtype=float))
CVR_mean_greedy=np.array(np.loadtxt("greedy_constraint_violation_mean_file.txt",dtype=float))
CVR_sd=np.array(np.loadtxt("centralized_learner_constraint_violation_sd_file.txt",dtype=float))
CVR_sd1=np.array(np.loadtxt("learner1_constraint_violation_sd_file.txt",dtype=float))
CVR_sd2=np.array(np.loadtxt("learner2_constraint_violation_sd_file.txt",dtype=float))
CVR_sd_follow=np.array(np.loadtxt("follow_constraint_violation_sd_file.txt",dtype=float))
CVR_sd_double=np.array(np.loadtxt("double_constraint_violation_sd_file.txt",dtype=float))
CVR_sd_greedy=np.array(np.loadtxt("greedy_constraint_violation_sd_file.txt",dtype=float))

SR_mean=np.array(np.loadtxt("centralized_learner_success_mean_file.txt",dtype=float))
SR_mean1=np.array(np.loadtxt("learner1_success_mean_file.txt",dtype=float))
SR_mean2=np.array(np.loadtxt("learner2_success_mean_file.txt",dtype=float))
SR_mean_follow=np.array(np.loadtxt("follow_success_mean_file.txt",dtype=float))
SR_mean_double=np.array(np.loadtxt("double_success_mean_file.txt",dtype=float))
SR_mean_greedy=np.array(np.loadtxt("greedy_success_mean_file.txt",dtype=float))
SR_sd=np.array(np.loadtxt("centralized_learner_success_sd_file.txt",dtype=float))
SR_sd1=np.array(np.loadtxt("learner1_success_sd_file.txt",dtype=float))
SR_sd2=np.array(np.loadtxt("learner2_success_sd_file.txt",dtype=float))
SR_sd_follow=np.array(np.loadtxt("follow_success_sd_file.txt",dtype=float))
SR_sd_double=np.array(np.loadtxt("double_success_sd_file.txt",dtype=float))
SR_sd_greedy=np.array(np.loadtxt("greedy_success_sd_file.txt",dtype=float))

plt.rcParams.update({'font.size': 14})
axis=np.arange(0,41,2)

fig, ax = plt.subplots()
ax.plot(axis,FPR_mean,'-')
ax.fill_between(axis,FPR_mean-FPR_sd,FPR_mean+FPR_sd,alpha=0.2)
ax.plot(axis,FPR_mean1,'--')
ax.fill_between(axis,FPR_mean1-FPR_sd1,FPR_mean1+FPR_sd1,alpha=0.2)
ax.plot(axis,FPR_mean2,'-.')
ax.fill_between(axis,FPR_mean2-FPR_sd2,FPR_mean2+FPR_sd2,alpha=0.2)
ax.plot(axis,FPR_mean_follow,':')
ax.fill_between(axis,FPR_mean_follow-FPR_sd_follow,FPR_mean_follow+FPR_sd_follow,alpha=0.2)
ax.plot(axis,FPR_mean_double,'.')
ax.fill_between(axis,FPR_mean_double-FPR_sd_double,FPR_mean_double+FPR_sd_double,alpha=0.2)
ax.plot(axis,FPR_mean_greedy,'<-')
ax.fill_between(axis,FPR_mean_greedy-FPR_sd_greedy,FPR_mean_greedy+FPR_sd_greedy,alpha=0.2)
plt.xticks(np.arange(0,41,10))
plt.xlabel('Demonstrations')
plt.show()

fig, ax = plt.subplots()
ax.plot(axis,FNR_mean,'-')
ax.fill_between(axis,FNR_mean-FNR_sd,FNR_mean+FNR_sd,alpha=0.2)
ax.plot(axis,FNR_mean1,'--')
ax.fill_between(axis,FNR_mean1-FNR_sd1,FNR_mean1+FNR_sd1,alpha=0.2)
ax.plot(axis,FNR_mean2,'-.')
ax.fill_between(axis,FNR_mean2-FNR_sd2,FNR_mean2+FNR_sd2,alpha=0.2)
ax.plot(axis,FNR_mean_follow,':')
ax.fill_between(axis,FNR_mean_follow-FNR_sd_follow,FNR_mean_follow+FNR_sd_follow,alpha=0.2)
ax.plot(axis,FNR_mean_double,'.')
ax.fill_between(axis,FNR_mean_double-FNR_sd_double,FNR_mean_double+FNR_sd_double,alpha=0.2)
ax.plot(axis,FNR_mean_greedy,'<-')
ax.fill_between(axis,FNR_mean_greedy-FNR_sd_greedy,FNR_mean_greedy+FNR_sd_greedy,alpha=0.2)
plt.xticks(np.arange(0,41,10))
plt.xlabel('Demonstrations')
plt.show()

fig, ax = plt.subplots()
ax.plot(axis,CVR_mean,'-')
ax.fill_between(axis,CVR_mean-CVR_sd,CVR_mean+CVR_sd,alpha=0.2)
ax.plot(axis,CVR_mean1,'--')
ax.fill_between(axis,CVR_mean1-CVR_sd1,CVR_mean1+CVR_sd1,alpha=0.2)
ax.plot(axis,CVR_mean2,'-.')
ax.fill_between(axis,CVR_mean2-CVR_sd2,CVR_mean2+CVR_sd2,alpha=0.2)
ax.plot(axis,CVR_mean_follow,':')
ax.fill_between(axis,CVR_mean_follow-CVR_sd_follow,CVR_mean_follow+CVR_sd_follow,alpha=0.2)
ax.plot(axis,CVR_mean_double,'.')
ax.fill_between(axis,CVR_mean_double-CVR_sd_double,CVR_mean_double+CVR_sd_double,alpha=0.2)
ax.plot(axis,CVR_mean_greedy,'<-')
ax.fill_between(axis,CVR_mean_greedy-CVR_sd_greedy,CVR_mean_greedy+CVR_sd_greedy,alpha=0.2)
plt.xticks(np.arange(0,41,10))
plt.xlabel('Demonstrations')
plt.show()

fig, ax = plt.subplots()
ax.plot(axis,SR_mean,'-')
ax.fill_between(axis,SR_mean-SR_sd,SR_mean+SR_sd,alpha=0.2)
ax.plot(axis,SR_mean1,'--')
ax.fill_between(axis,SR_mean1-SR_sd1,SR_mean1+SR_sd1,alpha=0.2)
ax.plot(axis,SR_mean2,'-.')
ax.fill_between(axis,SR_mean2-SR_sd2,SR_mean2+SR_sd2,alpha=0.2)
ax.plot(axis,SR_mean_follow,':')
ax.fill_between(axis,SR_mean_follow-SR_sd_follow,SR_mean_follow+SR_sd_follow,alpha=0.2)
ax.plot(axis,SR_mean_double,'.')
ax.fill_between(axis,SR_mean_double-SR_sd_double,SR_mean_double+SR_sd_double,alpha=0.2)
ax.plot(axis,SR_mean_greedy,'<-')
ax.fill_between(axis,SR_mean_greedy-SR_sd_greedy,SR_mean_greedy+SR_sd_greedy,alpha=0.2)
plt.xticks(np.arange(0,41,10))
plt.xlabel('Demonstrations')
plt.show()






